/* Trang web Đại Tạng Kinh được lập trình bởi Xuân Duật và đây là mã nguồn mở */

function number2viet(s)
{
	var str = '';
	var strEND = '';
	if(s.length == 0) return 'NaN';
	if(s.substr(0, 1) == '-')
	{
		str = 'âm ';
		s = s.substr(1);
	}
	
	if(s.substr(s.length - 1, 1) == '%')
	{
		strEND = ' phần trăm';
		s = s.substr(0, s.length - 1);
	}
	
	var a = s.split(',');
	if(a.length == 1)
	{
		s = s.replace(/\./g, '');
		if(s.indexOf('/') != -1)
		{
			var slash = s.split('/');
			if(slash.length == 2 && slash[0] != '' && slash[1] !='' && !isNaN(slash[0]) && !isNaN(slash[1]))
			{
				return numberFinal(str + numberParse(slash[0]) + ' phần ' + numberParse(slash[1]) + strEND);
			}
			else return 'NaN';
		}
		else if(isNaN(s)) return 'NaN';
		else return numberFinal(str + numberParse(s) + strEND);
	}
	else if(a.length == 2)
	{
		var s0 = a[0];
		var s1 = a[1];
		s0 = s0.replace(/\./g, '');
		s1 = s1.replace(/\./g, '');
		if(isNaN(s0) || isNaN(s1)) return 'NaN';
		else
		{
			var beforeDecimal = '';
			var afterDecimal = '';
			var zeros = '';
			var whiletrue = true;
			for(var i = 0; i < s1.length; i++)
			{
				var charAt = s1.charAt(i);
				if(whiletrue && charAt == '0') zeros += numberLessThan20(charAt) + ' ';
				else
				{
					whiletrue = false;
					break;
				}
			}
			if(s0.length != 0) beforeDecimal = numberParse(s0);
			if(s1.length != 0) afterDecimal = numberParse(s1);
			return numberFinal(str + beforeDecimal + ' phết ' + zeros + afterDecimal + strEND);
		}
	}
	else return 'NaN';
}
function numberParse(s)
{
	var n = parseInt(s);
	if(n < 20) return numberLessThan20(n);
	else if(n < 100) return numberLessThanOneHundred(n);
	else if(n < 1000) return numberLessThanOneThousand(n);
	else if(n < 1000000) return numberLessThanOneMillion(n);
	else if(n < 1000000000) return numberLessThanOneBillion(n);
	else return numberElse(n);
}
function numberLessThan20(n)
{
	var a = ['dê rô', 'một','hai','ba','bốn','năm','sáu','bảy','tám','chín','mười','mười một','mười hai','mười ba','mười bốn','mười lăm','mười sáu','mười bảy','mười tám','mười chín'];
	return a[n];
}
function numberLessThanOneHundred(n)
{
	var a = ['hai mươi','ba mươi','bốn mươi','năm mươi','sáu mươi','bảy mươi','tám mươi','chín mươi'];
	var index = Math.floor((n/10));
	var num = n % 10;
	var str = '';
	if(num) str = ' ' + numberLessThan20(num);
	return (index >= 2 ? a[index-2] : '') + str;
}
function numberLessThanOneThousand(n)
{
	var a = ['một trăm','hai trăm','ba trăm','bốn trăm','năm trăm','sáu trăm','bảy trăm','tám trăm','chín trăm','một nghìn'];
	var index = Math.floor((n/100));
	var num = n % 100;
	var str = '';
	if(num && num <= 9) str = ' linh ' + numberLessThan20(num);
	else if(num >= 10 && num <= 19 ) str = ' ' + numberLessThan20(num);
	else if(num) str = ' ' + numberLessThanOneHundred(num);
	return (index >= 1 ? a[index-1] : '') + str;
}
function numberLessThanOneMillion(n)
{
	var s1 = '';
	var s2 = '';
	var thousand = Math.floor((n/1000));
	var remainder = n % 1000;
	if(thousand && thousand < 20) s1 = numberLessThan20(thousand) + ' nghìn';
	else if(thousand && thousand < 100) s1 = numberLessThanOneHundred(thousand) + ' nghìn';
	else if(thousand && thousand < 1000) s1 = numberLessThanOneThousand(thousand) + ' nghìn';
	
	if(remainder) s2 = ' ' + numberLessThanOneThousand(remainder);
	
	return s1 + s2;
}
function numberLessThanOneBillion(n)
{
	var s1 = '';
	var s2 = '';
	var million = Math.floor((n/1000000));
	var remainder = n % 1000000;
	
	if(million && million < 20) s1 = numberLessThan20(million) + ' triệu';
	else if(million && million < 100) s1 = numberLessThanOneHundred(million) + ' triệu';
	else if(million && million < 1000) s1 = numberLessThanOneThousand(million) + ' triệu';
	
	if(remainder) s2 = ' ' + numberLessThanOneMillion(remainder);
	
	return s1 + s2;
}
function numberElse(n)
{
	var s1 = '';
	var s2 = '';
	var billion = Math.floor((n/1000000000));
	var remainder = n % 1000000000;
	
	if(billion && billion < 20) s1 = numberLessThan20(billion) + ' tỷ';
	else if(billion && billion < 100) s1 = numberLessThanOneHundred(billion) + ' tỷ';
	else if(billion && billion < 1000) s1 = numberLessThanOneThousand(billion) + ' tỷ';
	else if(billion && billion < 1000000) s1 = numberLessThanOneMillion(billion) + ' tỷ';
	else if(billion && billion < 1000000000) s1 = numberLessThanOneBillion(billion) + ' tỷ';
	else
	{
		var str = billion.toString();
		for(var i = 0; i < str.length; i++)
		{
			s1 += numberLessThan20(str.charAt(i)) + ' ';
		}
		s1 += 'tỷ';
	}
	
	if(remainder) s2 = ' ' + numberLessThanOneBillion(remainder);
	
	return s1 + s2;
}
function numberFinal(s)
{
	if(vidialect == 'nam')
	{
		s = s.replace(/phết/g, 'phẩy');
		s = s.replace(/linh/g, 'lẻ');
		s = s.replace(/nghìn/g, 'ngàn');
		s = s.replace(/mươi năm/g, 'mươi lăm');
	}
	else
	{
		s = s.replace(/mươi năm/g, 'mươi nhăm');
	}
	s = s.replace(/mươi một/g, 'mươi mốt');
	return s;
}